% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{felt_get_map}
\alias{felt_get_map}
\alias{felt_get_map_layers}
\alias{felt_get_map_layer}
\title{Get Map Information from Map ID}
\usage{
felt_get_map(map_id, clean = TRUE)

felt_get_map_layers(map_id, clean = TRUE)

felt_get_map_layer(map_id, layer_id, clean = TRUE)
}
\arguments{
\item{map_id}{character, map identifier from url, from \verb{https://felt.com/map/Readable-Name-map_id}}

\item{clean}{logical, whether to turn the API response into a \link[tibble:tibble]{tibble::tibble}}

\item{layer_id}{character, layer identifier from url, from \code{felt_get_map()}}
}
\value{
a \link[tibble:tibble]{tibble::tibble} for the map, if \code{clean = TRUE}, otherwise a list
}
\description{
\itemize{
\item \code{felt_get_map()} returns identifying information for the map
\item \code{felt_get_map_layers()} returns information about each layer in the map
\item \code{felt_get_map_elements()} returns the shapes for each layer in the map
}
}
\examples{
\dontshow{if (has_felt_key()) withAutoprint(\{ # examplesIf}
felt_get_map('Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA')
felt_get_map_layers('Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA')
\donttest{
# slower, as it has to build the shapes from the API result
felt_get_map_elements('Rockland-2024-Districts-TBI8sDkmQjuK2GX9CSiHiUA')
}
\dontshow{\}) # examplesIf}
}
\concept{get}
