% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Guard.R
\name{Guard}
\alias{Guard}
\alias{is_guard}
\title{R6 base class for guards}
\usage{
is_guard(x)
}
\arguments{
\item{x}{An object}
}
\description{
All guards inherit from this base class and adapts it for the particular
scheme it implements. Additional schemes can be implemented as subclasses of
this and will work transparently with fireproof.
}
\examples{
# You'd never actually do this, rather you'd use the subclasses
guard <- Guard$new(name = "base_auth")

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{The name of the instance}

\item{\code{open_api}}{An OpenID compliant security scheme description}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Guard-new}{\code{Guard$new()}}
\item \href{#method-Guard-check_request}{\code{Guard$check_request()}}
\item \href{#method-Guard-reject_response}{\code{Guard$reject_response()}}
\item \href{#method-Guard-forbid_user}{\code{Guard$forbid_user()}}
\item \href{#method-Guard-register_handler}{\code{Guard$register_handler()}}
\item \href{#method-Guard-clone}{\code{Guard$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-new"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-new}{}}}
\subsection{Method \code{new()}}{
Constructor for the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$new(name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the scheme instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-check_request"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-check_request}{}}}
\subsection{Method \code{check_request()}}{
A function that validates an incoming request, returning
\code{TRUE} if it is valid and \code{FALSE} if not. The base class simply returns
\code{TRUE} for all requests
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$check_request(request, response, keys, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to validate as a \link[reqres:Request]{Request}
object}

\item{\code{response}}{The corresponding response to the request as a
\link[reqres:Response]{Response} object}

\item{\code{keys}}{A named list of path parameters from the path matching}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-reject_response"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-reject_response}{}}}
\subsection{Method \code{reject_response()}}{
Action to perform on the response in case the request fails
to get validated by any instance in the flow. All failing instances will
have this method called one by one so be mindful if you are overwriting
information set by another instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$reject_response(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-forbid_user"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-forbid_user}{}}}
\subsection{Method \code{forbid_user()}}{
Action to perform on the response in case the request does
not have the necessary permissions for the endpoint. All succeeding
instances will have this method called one by one if permissions are
insufficient so be mindful if you are overwriting information set by
another instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$forbid_user(response, scope, ..., .datastore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{response}}{The response object}

\item{\code{scope}}{The scope of the endpoint}

\item{\code{...}}{Ignored}

\item{\code{.datastore}}{The data storage from firesale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-register_handler"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-register_handler}{}}}
\subsection{Method \code{register_handler()}}{
Hook for registering endpoint handlers needed for this
auth method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$register_handler(add_handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{add_handler}}{The \code{add_handler} method from \link{Fireproof} to be called
for adding additional handlers}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Guard-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Guard-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Guard$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
