% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAccessControlListManager.R
\docType{class}
\name{GSAccessControlListManager}
\alias{GSAccessControlListManager}
\title{Geoserver REST API Access Control List Manager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for managing GeoServer
Access Control List (ACL) operations.
}
\description{
Geoserver REST API Access Control List Manager

Geoserver REST API Access Control List Manager
}
\examples{
\dontrun{
   GSAccessControlListManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ACL}
\keyword{access}
\keyword{api}
\keyword{control}
\keyword{geoserver}
\keyword{list}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSManager]{geosapi::GSManager}} -> \code{GSAccessControlListManager}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSAccessControlListManager-setCatalogMode}{\code{GSAccessControlListManager$setCatalogMode()}}
\item \href{#method-GSAccessControlListManager-getCatalogMode}{\code{GSAccessControlListManager$getCatalogMode()}}
\item \href{#method-GSAccessControlListManager-getRules}{\code{GSAccessControlListManager$getRules()}}
\item \href{#method-GSAccessControlListManager-addRule}{\code{GSAccessControlListManager$addRule()}}
\item \href{#method-GSAccessControlListManager-addLayerRule}{\code{GSAccessControlListManager$addLayerRule()}}
\item \href{#method-GSAccessControlListManager-addServiceRule}{\code{GSAccessControlListManager$addServiceRule()}}
\item \href{#method-GSAccessControlListManager-addRestRule}{\code{GSAccessControlListManager$addRestRule()}}
\item \href{#method-GSAccessControlListManager-modifyRule}{\code{GSAccessControlListManager$modifyRule()}}
\item \href{#method-GSAccessControlListManager-deleteRule}{\code{GSAccessControlListManager$deleteRule()}}
\item \href{#method-GSAccessControlListManager-clone}{\code{GSAccessControlListManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="ERROR"><a href='../../geosapi/html/GSManager.html#method-GSManager-ERROR'><code>geosapi::GSManager$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="INFO"><a href='../../geosapi/html/GSManager.html#method-GSManager-INFO'><code>geosapi::GSManager$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="WARN"><a href='../../geosapi/html/GSManager.html#method-GSManager-WARN'><code>geosapi::GSManager$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="connect"><a href='../../geosapi/html/GSManager.html#method-GSManager-connect'><code>geosapi::GSManager$connect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getClassName"><a href='../../geosapi/html/GSManager.html#method-GSManager-getClassName'><code>geosapi::GSManager$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getCoverageStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getCoverageStoreManager'><code>geosapi::GSManager$getCoverageStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getDataStoreManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getDataStoreManager'><code>geosapi::GSManager$getDataStoreManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getNamespaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getNamespaceManager'><code>geosapi::GSManager$getNamespaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getServiceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getServiceManager'><code>geosapi::GSManager$getServiceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getStyleManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getStyleManager'><code>geosapi::GSManager$getStyleManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getSystemStatus"><a href='../../geosapi/html/GSManager.html#method-GSManager-getSystemStatus'><code>geosapi::GSManager$getSystemStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getUrl"><a href='../../geosapi/html/GSManager.html#method-GSManager-getUrl'><code>geosapi::GSManager$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="getWorkspaceManager"><a href='../../geosapi/html/GSManager.html#method-GSManager-getWorkspaceManager'><code>geosapi::GSManager$getWorkspaceManager()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="initialize"><a href='../../geosapi/html/GSManager.html#method-GSManager-initialize'><code>geosapi::GSManager$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="logger"><a href='../../geosapi/html/GSManager.html#method-GSManager-logger'><code>geosapi::GSManager$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="monitor"><a href='../../geosapi/html/GSManager.html#method-GSManager-monitor'><code>geosapi::GSManager$monitor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSManager" data-id="reload"><a href='../../geosapi/html/GSManager.html#method-GSManager-reload'><code>geosapi::GSManager$reload()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-setCatalogMode"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-setCatalogMode}{}}}
\subsection{Method \code{setCatalogMode()}}{
Set the catalog mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$setCatalogMode(
  mode = c("HIDE", "MIXED", "CHALLENGE")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{mode}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-getCatalogMode"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-getCatalogMode}{}}}
\subsection{Method \code{getCatalogMode()}}{
Get the catalog mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$getCatalogMode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the mode either \code{HIDE}, \code{MIXED} or \code{CHALLENGE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-getRules"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-getRules}{}}}
\subsection{Method \code{getRules()}}{
Get rules
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$getRules(domain = c("layers", "services", "rest"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{domain}}{the access control domain}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the list of rules for a given domain
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-addRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-addRule}{}}}
\subsection{Method \code{addRule()}}{
Generic method to add an access control rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$addRule(rule)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rule}}{object of class \link{GSRule}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-addLayerRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-addLayerRule}{}}}
\subsection{Method \code{addLayerRule()}}{
Adds an access control layer rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$addLayerRule(
  ws = NULL,
  lyr,
  permission = c("r", "w", "a"),
  roles
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{the resource workspace. Default is \code{NULL}}

\item{\code{lyr}}{the target layer to which the access control should be added}

\item{\code{permission}}{the rule permission, either \code{r} (read), \code{w} (write) or \code{a} (administer)}

\item{\code{roles}}{one or more roles to add for the rule}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-addServiceRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-addServiceRule}{}}}
\subsection{Method \code{addServiceRule()}}{
Adds an access control service rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$addServiceRule(
  service,
  method,
  permission = c("r", "w", "a"),
  roles
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{service subject to the access control rule, eg. 'wfs'}

\item{\code{method}}{service method subject to the access control rule, eg. 'GetFeature'}

\item{\code{permission}}{the rule permission, either \code{r} (read), \code{w} (write) or \code{a} (administer)}

\item{\code{roles}}{one or more roles to add for the rule}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-addRestRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-addRestRule}{}}}
\subsection{Method \code{addRestRule()}}{
Adds an access control rest rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$addRestRule(
  pattern,
  methods,
  permission = c("r", "w", "a"),
  roles
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{a URL Ant pattern, only applicable for domain \code{rest}. Default is \code{/**}}

\item{\code{methods}}{HTTP method(s)}

\item{\code{permission}}{the rule permission, either \code{r} (read), \code{w} (write) or \code{a} (administer)}

\item{\code{roles}}{one or more roles to add for the rule}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-modifyRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-modifyRule}{}}}
\subsection{Method \code{modifyRule()}}{
Generic method to modify an access control rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$modifyRule(rule)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rule}}{object of class \link{GSRule}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if modified, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-deleteRule"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-deleteRule}{}}}
\subsection{Method \code{deleteRule()}}{
Generic method to delete an access control rule
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$deleteRule(rule)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rule}}{object of class \link{GSRule}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSAccessControlListManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSAccessControlListManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSAccessControlListManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
