% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_axes.R
\name{collect_axes}
\alias{collect_axes}
\alias{align_guides_h}
\title{Collect Axes from Patchwork Compositions}
\usage{
collect_axes(x, guides = c("collect", "keep"))

align_guides_h(x, guides = c("collect", "keep"))
}
\arguments{
\item{x}{A patchwork object created by combining ggplot2 plots.}

\item{guides}{How to handle guides. Either \code{"collect"} to combine into a
single legend (default), or \code{"keep"} to maintain separate legends.}
}
\value{
A patchwork object with collected axes.
}
\description{
Collects duplicate axes from multiple plots in a patchwork composition,
removing redundant axis labels and ticks. This is a convenience wrapper
around patchwork's axis collection functionality.
}
\details{
This function applies patchwork's \code{axes = "collect"} layout option,
which removes duplicate axes when plots are stacked or placed side-by-side.
For example, in a 2x1 vertical layout, the x-axis labels on the top plot
will be removed since they are redundant with the bottom plot's x-axis.

When \code{guides = "collect"}, legends are also merged into a single
shared legend.

For cowplot: Axis alignment in cowplot requires manual use of
\code{\link[cowplot]{align_plots}} with \code{align = "h"} or \code{"v"}.
This function does not directly support cowplot objects.
}
\examples{
library(ggplot2)

if (requireNamespace("patchwork", quietly = TRUE)) {
  library(patchwork)

  # Two plots stacked vertically - x-axis is duplicated
  p1 <- ggplot(mtcars, aes(mpg, wt, color = factor(cyl))) +
    geom_point() +
    labs(y = "Weight")
  p2 <- ggplot(mtcars, aes(mpg, hp, color = factor(cyl))) +
    geom_point() +
    labs(y = "Horsepower")

  # Without collect_axes: both plots show x-axis
  p1 / p2

  # With collect_axes: removes redundant x-axis from top plot
  collect_axes(p1 / p2)

  # Keep separate legends
  collect_axes(p1 / p2, guides = "keep")
}

}
\seealso{
\code{\link{collect_legends}}, \code{\link{legend_left}}, \code{\link{legend_wrap}}
}
