% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorbar_style.R
\name{colorbar_style}
\alias{colorbar_style}
\alias{colourbar_style}
\title{Style Continuous Color Bar Legends}
\usage{
colorbar_style(
  width = NULL,
  height = NULL,
  ticks = NULL,
  ticks_length = NULL,
  frame = NULL,
  frame_linewidth = NULL,
  label = NULL,
  label_position = NULL,
  title_position = NULL,
  direction = NULL,
  reverse = NULL,
  nbin = NULL,
  aesthetic = "colour"
)

colourbar_style(
  width = NULL,
  height = NULL,
  ticks = NULL,
  ticks_length = NULL,
  frame = NULL,
  frame_linewidth = NULL,
  label = NULL,
  label_position = NULL,
  title_position = NULL,
  direction = NULL,
  reverse = NULL,
  nbin = NULL,
  aesthetic = "colour"
)
}
\arguments{
\item{width}{Numeric. Width of the color bar in lines. Default is 1.}

\item{height}{Numeric. Height of the color bar in lines. Default is 5.}

\item{ticks}{Logical. Whether to show tick marks. Default is TRUE.}

\item{ticks_length}{Numeric. Length of tick marks in lines. Default is 0.2.}

\item{frame}{Logical or character. If TRUE, draws a black frame. If a color
string, draws a frame in that color. If FALSE or NULL, no frame. Default is FALSE.}

\item{frame_linewidth}{Numeric. Line width of the frame. Default is 0.5.}

\item{label}{Logical. Whether to show labels. Default is TRUE.}

\item{label_position}{Character. Position of labels: "right", "left", "top",
or "bottom". Default depends on bar orientation.}

\item{title_position}{Character. Position of title: "top", "bottom", "left",
or "right". Default is "top".}

\item{direction}{Character. Direction of the bar: "vertical" or "horizontal".
Default is "vertical".}

\item{reverse}{Logical. Whether to reverse the color bar. Default is FALSE.}

\item{nbin}{Integer. Number of bins used to draw the color bar. Higher values
give smoother gradients. Default is 300.}

\item{aesthetic}{Character. Which aesthetic to apply to. Default is "colour".
Common values: "colour", "color", "fill".}
}
\value{
A ggplot2 guides specification.
}
\description{
Customize the appearance of color bar legends for continuous scales.
This provides a simpler interface to \code{guide_colourbar()}.
}
\details{
This function simplifies common color bar customizations:
\itemize{
\item \strong{Size}: Use \code{width} and \code{height} to make thin/wide bars
\item \strong{Ticks}: Toggle with \code{ticks}, adjust length with \code{ticks_length}
\item \strong{Frame}: Add a border with \code{frame = TRUE} or \code{frame = "grey50"}
\item \strong{Orientation}: Use \code{direction = "horizontal"} for horizontal bars
}

The function uses the theme system internally, which is the recommended
approach in ggplot2 3.5.0+.
}
\examples{
library(ggplot2)

p <- ggplot(faithfuld, aes(waiting, eruptions, fill = density)) +
  geom_tile()

# Default appearance
p

# Taller, thinner bar
p + colorbar_style(width = 0.5, height = 10, aesthetic = "fill")

# Wide horizontal bar
p + colorbar_style(width = 10, height = 0.5, direction = "horizontal",
                   aesthetic = "fill")

# With frame and no ticks
p + colorbar_style(frame = "grey50", ticks = FALSE, aesthetic = "fill")

# Thin bar with frame
p + colorbar_style(width = 0.5, height = 8, frame = TRUE, aesthetic = "fill")

}
\seealso{
\code{\link{legend_style}} for styling discrete legends,
\code{\link{legend_left}}, \code{\link{legend_bottom}} for positioning.
}
