% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdMTD_FS.R
\name{hdMTD_FS}
\alias{hdMTD_FS}
\title{The Forward Stepwise (FS) method for inference in MTD models}
\usage{
hdMTD_FS(X, d, l, A = NULL, elbowTest = FALSE, warn = FALSE, ...)
}
\arguments{
\item{X}{A vector or single-column data frame containing a chain sample (\code{X[1]} is the most recent).}

\item{d}{A positive integer representing an upper bound for the chain order.}

\item{l}{A positive integer specifying the number of lags to be selected as relevant.}

\item{A}{A vector with positive integers representing the state space. If not informed,
this function will set \code{A <- sort(unique(X))}.}

\item{elbowTest}{Logical. If TRUE, the function applies an alternative stopping criterion to
determine the length of the set of relevant lags. See \emph{Details} for more information.}

\item{warn}{Logical. If \code{TRUE}, the function warns the user when \code{A} is set automatically.}

\item{...}{Additional arguments (not used in this function, but maintained for compatibility with \code{\link[=hdMTD]{hdMTD()}}.}
}
\value{
A numeric vector containing the estimated relevant lag set using FS algorithm.
}
\description{
A function that estimates the set of relevant lags of an MTD model using the FS method.
}
\details{
The "Forward Stepwise" (FS) algorithm is the first step of the "Forward Stepwise and Cut"
(FSC) algorithm for inference in Mixture Transition Distribution (MTD) models.
This method was developed by \href{http://jmlr.org/papers/v24/22-0266.html}{Ost and Takahashi}.
This specific function will only apply the FS step of the algorithm and return an estimated
relevant lag set of length \code{l}.

This method iteratively selects the most relevant lags based on a certain quantity \eqn{\nu}.
In the first step, the lag in \code{1:d} with the greatest \eqn{\nu} is deemed important.
This lag is included in the output, and using this knowledge, the function proceeds to seek
the next important lag (the one with the highest \eqn{\nu} among the remaining ones).
The process stops when the output vector reaches length \code{l} if \code{elbowTest=FALSE}.

If \code{elbowTest = TRUE}, the function will store these maximum \eqn{\nu} values
at each iteration, and output only the lags that appear before the one with smallest
\eqn{\nu} among them.
}
\note{
Tie-breaking: if multiple lags share the maximum \eqn{\nu}, FS picks the most recent
lag (smallest j). Up to version 0.1.2 ties were broken at random, which could cause
run-to-run differences.
}
\examples{
# Simulate a chain from an MTD model
set.seed(1)
M <- MTDmodel(Lambda = c(1, 3), A = c(1, 2), lam0 = 0.05)
X <- perfectSample(M, N = 400)

# Forward Stepwise with l = 2
hdMTD_FS(X, d = 5, l = 2)

# Forward Stepwise with l = 3
hdMTD_FS(X, d = 4, l = 3)

}
\references{
Ost, G. & Takahashi, D. Y. (2023).
Sparse Markov models for high-dimensional inference.
\emph{Journal of Machine Learning Research}, \emph{24}(279), 1-54.
\url{http://jmlr.org/papers/v24/22-0266.html}
}
