% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlon.R
\name{compress_latlon}
\alias{compress_latlon}
\alias{decompress_latlon}
\alias{compress_latlon_general}
\alias{decompress_latlon_general}
\title{Compress latitude and longitude to a 32-bit integer}
\usage{
compress_latlon(lat, lon, nThread = getOption("healthyAddress.nThread", 1L))

decompress_latlon(x, nThread = getOption("healthyAddress.nThread", 1L))

compress_latlon_general(
  lat,
  lon,
  nThread = getOption("healthyAddress.nThread", 1L)
)

decompress_latlon_general(x, nThread = getOption("healthyAddress.nThread", 1L))
}
\arguments{
\item{lat, lon}{Coordinates to compress.}

\item{nThread}{Number of threads to use.}

\item{x}{An integer vector formed by one of the compression functions.}
}
\value{
The \verb{_general} version of the compression/decompression use the observed
range of the latitude and longitude to form a \eqn{2^16} grid, while the
bare versions use the known limits of Australian address coordinates
(including the overseas territories). Since, in the latter, the grid
will be much less fine, you should expect greater loss of information,
possibly exceeding 100 metres.

\describe{
\item{\code{compress_latlon}}{An integer vector.}
\item{\code{decompress_latlon}}{The original \code{lat,lon}, with some information loss}
\item{\code{compress_latlon_general}}{An integer vector, with attributes \code{minmaxLat} and \code{minmaxLon}.}
\item{\code{decompress_latlon_general}}{The original \code{lat,lon}, with some information loss.}
}
}
\description{
Although lat and lon are represented by doubles, this is usually
slightly wasteful. This function allows you to represent coordinates as single
integer, vastly reducing memory footprint.
}
