% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmneighbourhood.R
\name{kmneighbourhood}
\alias{kmneighbourhood}
\title{Compute the neighbourhod of a state within a knowledge structure}
\usage{
kmneighbourhood(state, struct, include = FALSE)
}
\arguments{
\item{state}{Binary vector representing a knowledge state}

\item{struct}{Binary matrix representing a knowledge structure}

\item{include}{Boolean whether the original state should be included
in the result (default FALSE)}
}
\value{
Matrix containing the neighbouring states, one per row
}
\description{
\code{kmneighbourhood} computes the neighbourhood of a state
within a knowledge structure, i.e. the family of all other
states with a symmetric set difference of 1.
}
\examples{
kmneighbourhood(c(1,1,0,0), xpl$space)

}
\seealso{
Other Fringes & learning paths: 
\code{\link{kmbasisfringe}()},
\code{\link{kmbasisneighbourhood}()},
\code{\link{kmfringe}()},
\code{\link{kmgradations}()},
\code{\link{kmlearningpaths}()},
\code{\link{kmnneighbourhood}()}
}
\concept{Fringes & learning paths}
