% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lqmix.R
\name{predict.lqmix}
\alias{predict.lqmix}
\title{Predictions from an \code{lqmix} object}
\usage{
\method{predict}{lqmix}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{an \code{lqmix} object}

\item{newdata}{an optional data frame in which to look for variables with which to predict. If omitted, the fitted values are produced}

\item{\dots}{not used}
}
\value{
A matrix or an array of predictions, based on the estimated model.
}
\description{
Returns the predicted values for an object of class \code{\link{lqmix}}.
}
\details{
The function computes predictions for an object of \code{\link{class}} \code{\link{lqmix}}.
If the fitted model is based on TC, discrete, random coefficients only, a matrix of size \code{nsbjs x G} is given as output; if the fitted model is based on TV, discrete, random coefficients only, a matrix of size \code{nObs x m}; if the fitted model is based on both TC and TV, discrete, random coefficients, an array of size \code{nObs x G x m} is returned.
}
