#' Print function.
#' 
#' Print function.
#' 
#' @usage \method{print}{mc}(x, ...)
#' @param x An object of class mc.
#' @param ... Ignored.
#' 
#' @return No return value. Used for printing.
#' @author Mehdi Moradi \email{m2.moradi@yahoo.com}
#' @export
print.mc <- function(x, ...) {
  
    type <- attr(x, "type")
    mtype <- attr(x, "mtype")

    if(type != "local"){
      cols <- names(x)
      if (is.null(cols)) cols <- colnames(x)
      if (!"r" %in% cols && type == "global") stop("Data frame must have a column 'r'")
      
      mark_cols <- setdiff(cols, "r")
      n_marks <- length(mark_cols) 
    }
    
    if(type == "local" && mtype == "function-valued"){
      cols <- names(x)
      if (is.null(cols)) cols <- colnames(x)
      if (!"r" %in% cols && type == "global") stop("Data frame must have a column 'r'")
      n_marks <- 1
    }

    if(type == "local" && mtype == "real-valued"){
      cols <- names(x)
      if (is.null(cols)){
        if (is.null(cols)) cols <- colnames(x)
        n_marks <- 1
      } else{
        n_marks <- length(cols)
      }
      
      
    }
  
  # ----- Helper: identify name of function bw -----
  find_function_name <- function(f) {
    if (!is.function(f)) return(NULL)
    
    env_names <- c(".GlobalEnv", grep("^package:", search(), value = TRUE))
    
    for (env_name in env_names) {
      env <- if (env_name == ".GlobalEnv") .GlobalEnv else {
        pkg <- sub("^package:", "", env_name)
        tryCatch(asNamespace(pkg), error = function(e) NULL)
      }
      if (is.null(env)) next
      
      objs <- tryCatch(ls(env, all.names = TRUE), error = function(e) character(0))
      for (nm in objs) {
        val <- tryCatch(get(nm, envir = env), error = function(e) NULL)
        if (!is.null(val) && is.function(val) && identical(val, f)) {
          return(nm)    # return ONLY the function name
        }
      }
    }
    return(NULL)
  }
  
  # ----- Ordered Output -----
  
  # Header
  cat("Mark Correlation Function Estimates\n")
  cat("=================================\n")
  
  
  if(type=="global") {
    cat(sprintf("Number of marks: %d\n", n_marks))
  } else{
    if (n_marks > 1){
      cat(sprintf("Number of marks: %d\n", n_marks))
      cat(sprintf("Number of points: %d\n", length(colnames(x[[1]]))-1) )
    } else{
      cat(sprintf("Number of marks: %d\n", n_marks))
      cat(sprintf("Number of points: %d\n", length(colnames(x))-1))
    }
  }
  
  if(type=="global") {
    cat(sprintf("Range of distances (r): %.3f - %.3f\n", min(x$r), max(x$r)))
  } else{
    if (n_marks > 1){
      cat(sprintf("Range of distances (r): %.3f - %.3f\n", min(x[[1]][,"r"]), max(x[[1]][,"r"])))
    } else{
      cat(sprintf("Range of distances (r): %.3f - %.3f\n", min(x[,"r"]), max(x[,"r"])))
    }
   
  }
  

  if (!is.null(mtype))
    cat(sprintf("Type of mark: %s\n", mtype))
  
  
  type <- attr(x, "type")
  if (!is.null(type))
    cat(sprintf("Type of mark correlation function: %s\n", type))
  
  ftype <- attr(x, "ftype")
  if (!is.null(ftype))
    cat(sprintf("Type of test function: %s\n", ftype))
  
  method <- attr(x, "method")
  if (!is.null(method))
    cat(sprintf("Type of smoothing function: %s\n", method))
  
  correction <- attr(x, "correction")
  if (!is.null(correction))
    cat(sprintf("Type of edge correction: %s\n", correction))
  
  # ----- INTENSITY ESTIMATION LOGIC -----
  
  lambda <- attr(x, "lambda")                  # NEW
  method_lambda <- attr(x, "method_lambda")    # kernel / voronoi / none
  
  if (!is.null(lambda)) {
    # λ supplied → intensity is given
    cat("Type of intensity estimation approach: given by user\n")
  } else if (!is.null(method_lambda)) {
    # no lambda, but an estimation method exists
    cat(sprintf("Type of intensity estimation approach: %s\n", method_lambda))
  }
  
  # ----- Bandwidth: only if (1) kernel AND (2) lambda not supplied -----
  if (is.null(lambda) && !is.null(method_lambda) && identical(method_lambda, "kernel")) {
    bw_value <- attr(x, "bw")
    if (!is.null(bw_value)) {
      if (is.function(bw_value)) {
        
        fname <- find_function_name(bw_value)
        
        if (!is.null(fname)) {
          fname_clean <- sub(".*::", "", fname)  # strip any pkg prefix
          cat(sprintf("Bandwidth selection approach: %s\n", fname_clean))
        } else {
          cat(sprintf("Bandwidth selection approach: <anonymous function; %d args>\n",
                      length(formals(bw_value))))
        }
        
      } else {
        cat(sprintf("Bandwidth selection approach: %s\n", paste(bw_value, collapse = ", ")))
      }
    }
  }
  
  normalise <- attr(x, "normalise")
  if (!is.null(normalise))
    cat(sprintf("Normalise: %s\n", normalise))
  
  
  
  invisible(x)
}
