% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_rw.R
\name{mc_rw}
\alias{mc_rw}
\title{Random Walk Model Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. \emph{Journal of Statistical Software}, 84(4), 1--30.
}
\usage{
mc_rw(id, time, data, order = 1, proper = FALSE)
}
\arguments{
\item{id}{A character string giving the name of the column in
\code{data} that identifies subjects or clusters.}

\item{time}{A character string giving the name of the column in
\code{data} that indexes time or ordering within each subject.}

\item{data}{A data frame containing the variables specified in
\code{id} and \code{time}.}

\item{order}{A positive integer specifying the order of the random
walk model.}

\item{proper}{Logical indicating whether a proper random walk
specification should be used.}
}
\value{
If \code{proper = FALSE}, a list with a single component:
\describe{
  \item{Z1}{A sparse matrix of class \code{dgCMatrix} representing the
  random walk precision structure.}
}
If \code{proper = TRUE}, a list with two components:
\describe{
  \item{Z1}{A sparse diagonal matrix of class \code{dgCMatrix}.}
  \item{Z2}{A sparse off-diagonal matrix of class \code{dgCMatrix}.}
}
The matrices are ordered consistently with the original data.
}
\description{
Constructs the components of the matrix linear predictor associated
with random walk (RW) models for longitudinal or time series data.
The user may specify the order of the random walk process.
}
\details{
This function builds sparse precision matrix components corresponding
to random walk structures of a given order. It is primarily intended
for longitudinal data indexed by a subject identifier and a time
variable. For pure time series data, the same \code{id} value should
be used for all observations. When \code{proper = TRUE}, the precision
structure is decomposed into diagonal and off-diagonal components.
}
\examples{
id <- rep(1:2, each = 4)
time <- rep(1:4, 2)
data <- data.frame(id = id, time = time)
mc_rw(id = "id", time = "time", data = data, order = 1, proper = FALSE)
mc_rw(id = "id", time = "time", data = data, order = 1, proper = TRUE)
mc_rw(id = "id", time = "time", data = data, order = 2, proper = TRUE)

}
\seealso{
\code{mc_id}, \code{mc_dist}, \code{mc_car},
  \code{mc_ma}, \code{mc_mixed}, \code{mc_compute_rho}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
