% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_topics}
\alias{find_topics}
\title{Find topics on Meetup}
\usage{
find_topics(
  query,
  max_results = 200,
  handle_multiples = "list",
  extra_graphql = NULL,
  asis = FALSE,
  ...
)
}
\arguments{
\item{query}{A string query to search for topics.}

\item{max_results}{Maximum number of results to return. If set to NULL,
will return all available results (may take a long time).}

\item{handle_multiples}{Character. How to handle multiple matches. One of
"list" or "first", or "error".
If "list", return a list-column with all matches.
If "first", return only the first match.}

\item{extra_graphql}{A graphql object. Extra objects to return}

\item{asis}{Return the raw API response as-is without processing}

\item{...}{Used for parameter expansion, must be empty.}
}
\value{
A data frame of topics matching the search query.
}
\description{
Search for topics on Meetup using a query string.
This function allows you to find topics that match your search criteria.
}
\examples{
\dontshow{
vcr::insert_example_cassette("find_topics", package = "meetupr")
meetupr:::mock_if_no_auth()
}
find_topics("R", max_results = 10)
find_topics("Data Science", max_results = 5)
\dontshow{
vcr::eject_cassette()
}
}
