% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_quantile_all}
\alias{normalize_quantile_all}
\title{Normalize intensities across samples using standard Quantile Normalization}
\usage{
normalize_quantile_all(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
This is the standard approach for Quantile Normalization. Other sub-flavors are also available:
\itemize{
\item \code{\link[metamorphr]{normalize_quantile_group}}
\item \code{\link[metamorphr]{normalize_quantile_batch}}
\item \code{\link[metamorphr]{normalize_quantile_smooth}}
}

See References for more information.
}
\examples{
toy_metaboscape \%>\%
  normalize_quantile_all()
}
\references{
Y. Zhao, L. Wong, W. W. B. Goh, \emph{Sci Rep} \strong{2020}, \emph{10}, 15534, DOI 10.1038/s41598-020-72664-6.
}
