% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_quantile_group}
\alias{normalize_quantile_group}
\title{Normalize intensities across samples using grouped Quantile Normalization}
\usage{
normalize_quantile_group(data, group_column = .data$Group)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{group_column}{Which column should be used for grouping? Usually \code{grouping_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
This function performs a Quantile Normalization on each sub-group in the data set. \strong{It therefore requires grouping information}. See
Examples for more information. This approach might perform better than the standard approach, \code{\link[metamorphr]{normalize_quantile_all}},
if sub-groups are very different (e.g., when comparing cancer vs. normal tissue).

Other sub-flavors are also available:
\itemize{
\item \code{\link[metamorphr]{normalize_quantile_all}}
\item \code{\link[metamorphr]{normalize_quantile_batch}}
\item \code{\link[metamorphr]{normalize_quantile_smooth}}
}

See References for more information.
Note that it is equivalent to the 'Class-specific' normalization in Zhao \emph{et al.} but has been renamed for internal consistency.
}
\examples{
toy_metaboscape \%>\%
  # Metadata, including grouping information, must be added before using normalize_quantile_group()
  join_metadata(toy_metaboscape_metadata) \%>\%
  normalize_quantile_group(group_column = Group)
}
\references{
Y. Zhao, L. Wong, W. W. B. Goh, \emph{Sci Rep} \strong{2020}, \emph{10}, 15534, DOI 10.1038/s41598-020-72664-6.
}
