% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{delete_database}
\alias{delete_database}
\title{Drop a Database}
\usage{
delete_database(.con, database_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Name of the database to drop.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: drops the database and prints CLI status messages.
}
\description{
Drops a database from the current DuckDB or MotherDuck connection if it exists.
Prints a CLI status report after performing the operation.
}
\details{
\itemize{
\item Executes \verb{DROP DATABASE IF EXISTS <database_name>} to remove the database.
\item Intended for DuckDB or MotherDuck connections.
\item Prints user, database and action details using CLI helper functions.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
