% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrInteractions.R
\name{mrInteractions}
\alias{mrInteractions}
\title{Calculate and visualize feature interactions}
\usage{
mrInteractions(mrIMLobj, num_bootstrap = 1, feature = NULL, top_int = 10)
}
\arguments{
\item{mrIMLobj}{A list object output by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.}

\item{num_bootstrap}{The number of bootstrap samples to generate
(default: 1).}

\item{feature}{The response model for which detailed interaction plots should
be generated.}

\item{top_int}{The number of top interactions to display (default: 10).}
}
\value{
A list containing:
\itemize{
\item \verb{$p_h2}: An ordered bar plot of the variability in each response model that
is unexplained by the main effects.
\item \verb{$p_h2_overall}: An ordered bar plot of the percentage of prediction
variability that can be attributed to interactions with each predictor for the
model specified by \code{feature}.
\item \verb{$p_h2_pairwise}: An ordered bar plot of the strength of the two-way
interactions in the model specified by \code{feature}. The strength of an
interaction is taken to be the un-normalized square root of the
H2-pairwise statistic (which is on the prediction scale).
\item \verb{$h2_df}: A data frame of the H2 statistics for each response model, along
with bootstraps if applicable.
\item \verb{$h2_overall_df}: A data frame of the H2-overall statistics for the variable
in each response model, along with bootstraps if applicable.
\item \verb{$h2_pairwise_df}: A data frame of the H2-pairwise statistics for the
variable in each response model, along with bootstraps if applicable.
}
}
\description{
A wrapper around \code{\link[hstats:hstats]{hstats::hstats()}}. Calculates and visualizes H-statistics
for interactions in the model using bootstrapping. See \code{help("hstats")} for
details on H-statistics.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mrIML_rf <- mrIML::mrIML_bird_parasites_RF

mrIML_interactions_rf <- mrInteractions(
  mrIML_rf,
  num_bootstrap = 50,
  feature = "Plas"
)

mrIML_interactions_rf[[1]]
mrIML_interactions_rf[[2]]
mrIML_interactions_rf[[3]]
\dontshow{\}) # examplesIf}
}
