% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{carlos_step}
\alias{carlos_step}
\title{Define a step size for one of Wendy Carlos's scales}
\usage{
carlos_step(name = "alpha", weights = NULL, edo = 12)
}
\arguments{
\item{name}{Which of Carlos's four scales to create: \code{"alpha"}, \code{"beta"}, \code{"gamma"},
or \code{"delta"}. Defaults to \code{"alpha"}}

\item{weights}{Numeric vector of length 3 assigning the number of steps that correspond
to 3:2, 5:4, and 6:5, respectively. Overrides \code{name} if specified.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Single numeric value containing the step size for the desired scale
}
\description{
For her album \emph{Beauty in the Beast}, Wendy Carlos developed several
non-octave scales whose step sizes are calculated to optimize approximations
of three intervals: the 3:2 fifth, the 5:4 major third, and the 6:5 minor third.
The alpha, beta, gamma, and delta scales differ in terms of how strongly they
privilege each of those just intervals. The basic step size for each scale is
created by calling this function with the appropriate \code{name} argument (e.g. "alpha").
You can also choose your own weights for the three approximated just intervals, in
which case the \code{name} argument is overridden.
}
\examples{
alpha_scale <- (0:31) * carlos_step()
practically_12tet <- (0:24) * carlos_step(weights=c(7, 4, 3))
}
