% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_lite_struct_sf.R
\name{geo_lite_struct_sf}
\alias{geo_lite_struct_sf}
\title{Address search API in \CRANpkg{sf} format (structured query)}
\usage{
geo_lite_struct_sf(
  amenity = NULL,
  street = NULL,
  city = NULL,
  county = NULL,
  state = NULL,
  country = NULL,
  postalcode = NULL,
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{amenity}{Name and/or type of POI, see also \link{geo_amenity}.}

\item{street}{House number and street name.}

\item{city}{City.}

\item{county}{County.}

\item{state}{State.}

\item{country}{Country.}

\item{postalcode}{Postal Code.}

\item{limit}{Maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{\link[sf:sf]{sf}} object with the results.
}
\description{
Geocodes addresses already split into components and return the corresponding
spatial object. This function returns the spatial object associated with the
query using \CRANpkg{sf}, see \code{\link[=geo_lite_struct]{geo_lite_struct()}} for retrieving the data in
\code{\link[tibble:tibble]{tibble}} format.

This function correspond to the \strong{structured query} search described in the
\href{https://nominatim.org/release-docs/develop/api/Search/}{API endpoint}. For
performing a free-form search use \code{\link[=geo_lite_sf]{geo_lite_sf()}}.
}
\details{
The structured form of the search query allows to look up up an address that
is already split into its components. Each parameter represents a field of
the address. All parameters are optional. You should only use the ones that
are relevant for the address you want to geocode.

See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item Administrative areas, major buildings and the like will be
returned as polygons.
\item Rivers, roads and their like as lines.
\item Amenities may be points even in case of a \code{points_only = FALSE} call.
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
# Map

pl_mayor <- geo_lite_struct_sf(
  street = "Plaza Mayor",
  county = "Comunidad de Madrid",
  country = "Spain", limit = 50,
  full_results = TRUE, verbose = TRUE
)

# Outline
ccaa <- geo_lite_sf("Comunidad de Madrid, Spain", points_only = FALSE)

library(ggplot2)

if (any(!sf::st_is_empty(pl_mayor), !sf::st_is_empty(ccaa))) {
  ggplot(ccaa) +
    geom_sf() +
    geom_sf(data = pl_mayor, aes(shape = addresstype, color = addresstype))
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geo_lite_struct]{geo_lite_struct()}}.

Geocoding:
\code{\link{geo_address_lookup}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct}()}

Get \code{\link[sf:sf]{sf}} objects:
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{reverse_geo_lite_sf}()}
}
\concept{geocoding}
\concept{spatial}
