% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_rpttype.R
\name{fetch_rpttype}
\alias{fetch_rpttype}
\title{Determines Type of Report Template}
\usage{
fetch_rpttype(template = NULL, verbose = TRUE)
}
\arguments{
\item{template}{Name of PowerPoint (pptx or potx) or Word (docx or dotx) file}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned list.}
}
\value{
List with the following elements
\itemize{
\item{rpttype}: Either Word, PowerPoint or Unknown
\item{rptext}: Either docx, pptx, or Unknown
\item{rptobj}: Either rdocx, rpptx, or Unknown
\item{isgood}: Boolean variable indicating success or failure
\item{msgs}: Vector of messages
}
}
\description{
Based on the file extension for a template
}
\examples{
rpttype = fetch_rpttype(template=
  file.path(system.file(package="onbrand"), "templates", "report.pptx"))

}
