% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_set_sheetview}
\alias{wb_set_sheetview}
\title{Modify the default view of a worksheet}
\usage{
wb_set_sheetview(
  wb,
  sheet = current_sheet(),
  color_id = NULL,
  default_grid_color = NULL,
  right_to_left = NULL,
  show_formulas = NULL,
  show_grid_lines = NULL,
  show_outline_symbols = NULL,
  show_row_col_headers = NULL,
  show_ruler = NULL,
  show_white_space = NULL,
  show_zeros = NULL,
  tab_selected = NULL,
  top_left_cell = NULL,
  view = NULL,
  window_protection = NULL,
  workbook_view_id = NULL,
  zoom_scale = NULL,
  zoom_scale_normal = NULL,
  zoom_scale_page_layout_view = NULL,
  zoom_scale_sheet_layout_view = NULL,
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{sheet}

\item{color_id, default_grid_color}{Integer: A color, default is 64}

\item{right_to_left}{Logical: if \code{TRUE} column ordering is right  to left}

\item{show_formulas}{Logical: if \code{TRUE} cell formulas are shown}

\item{show_grid_lines}{Logical: if \code{TRUE} the worksheet grid is shown}

\item{show_outline_symbols}{Logical: if \code{TRUE} outline symbols are shown}

\item{show_row_col_headers}{Logical: if \code{TRUE} row and column headers are shown}

\item{show_ruler}{Logical: if \code{TRUE} a ruler is shown in page layout view}

\item{show_white_space}{Logical: if \code{TRUE} margins are shown in page layout view}

\item{show_zeros}{Logical: if \code{FALSE} cells containing zero are shown blank if \code{show_formulas = FALSE}}

\item{tab_selected}{Integer: zero vector indicating the selected tab}

\item{top_left_cell}{Cell: the cell shown in the top left corner / or top right with rightToLeft}

\item{view}{View: "normal", "pageBreakPreview" or "pageLayout"}

\item{window_protection}{Logical: if \code{TRUE} the panes are protected}

\item{workbook_view_id}{integer: Pointing to some other view inside the workbook}

\item{zoom_scale, zoom_scale_normal, zoom_scale_page_layout_view, zoom_scale_sheet_layout_view}{Integer: the zoom scale should be between 10 and 400. These are values for current, normal etc.}

\item{...}{additional arguments}
}
\value{
The \code{wbWorkbook} object, invisibly
}
\description{
This helps set a worksheet's appearance, such as the zoom, whether to show grid lines
}
\examples{
wb <- wb_workbook()$add_worksheet()

wb$set_sheetview(
  zoom_scale = 75,
  right_to_left = FALSE,
  show_formulas = TRUE,
  show_grid_lines = TRUE,
  show_outline_symbols = FALSE,
  show_row_col_headers = TRUE,
  show_ruler = TRUE,
  show_white_space = FALSE,
  tab_selected = 1,
  top_left_cell = "B1",
  view = "normal",
  window_protection = TRUE
)
}
