% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countryPackage.R
\name{countryPackage}
\alias{countryPackage}
\title{Tabulate a country's package downloads.}
\usage{
countryPackage(country = "HK", date = NULL, all.filters = FALSE,
  ip.filter = FALSE, sequence.filter = FALSE, size.filter = FALSE,
  small.filter = FALSE, version.filter = FALSE, sort.count = TRUE,
  memoization = TRUE, multi.core = FALSE)
}
\arguments{
\item{country}{Character. country abbreviation.}

\item{date}{Character. Date. "yyyy-mm-dd". NULL uses latest available log.}

\item{all.filters}{Logical. Master switch for filters.}

\item{ip.filter}{Logical.}

\item{sequence.filter}{Logical.}

\item{size.filter}{Logical.}

\item{small.filter}{Logical. TRUE filters out downloads less than 1000 bytes.}

\item{version.filter}{Logical. TRUE selects only most recent version.}

\item{sort.count}{Logical. Sort by download count.}

\item{memoization}{Logical. Use memoization when downloading logs.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores.}
}
\description{
From RStudio's CRAN Mirror http://cran-logs.rstudio.com/
}
\note{
all.filters = TRUE only enables IP and small filters. "US" outlier 10 min with all filters!
}
