% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pggm.R
\name{pggm}
\alias{pggm}
\title{Profile Boosting for Gaussian Graphical Model}
\usage{
pggm(
  S,
  nObs,
  maxK = floor(min(nObs - 1, NROW(S) - 1, 50)),
  digits = 8,
  verbose = FALSE
)
}
\arguments{
\item{S}{Covariance matrix.}

\item{nObs}{Number of observations.}

\item{maxK}{Maximum number of identified edges.}

\item{digits}{Integer indicating the number of decimal
places or significant digits to be used.}

\item{verbose}{Print the procedure path?}
}
\value{
Index set of identified features.
}
\description{
Profile boosting for Gaussian graphical model.
}
\examples{
library(MASS)
library(Matrix)

set.seed(2025)
n <- 1000
p <- 10

Omega <- Diagonal(p)
diag(Omega[1:4, 2:5]) <- diag(Omega[2:5, 1:4]) <- 0.5
Sigma <- chol2inv(chol(Omega))
X <- mvrnorm(n, rep(0, p), Sigma, empirical=TRUE)
S <- cov(X)
system.time( egg <- pggm(S, n) )

}
