% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas.r
\name{Canvas}
\alias{Canvas}
\title{Canvas Classes for Terminal Plotting}
\description{
Abstract canvas system that provides different rendering backends:
- AsciiCanvas: Basic ASCII characters (*, -, |, +)
- BrailleCanvas: Unicode Braille patterns (2x4 dots per cell = 8x resolution)
- BlockCanvas: Unicode block elements (half-blocks for 2x vertical resolution)
}
\details{
Abstract base class for all canvas types. Provides the interface
that all canvas implementations must follow.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{width}}{Character width of the canvas}

\item{\code{height}}{Character height of the canvas}

\item{\code{pixel_width}}{Pixel width (may be higher than char width for Braille/Block)}

\item{\code{pixel_height}}{Pixel height (may be higher than char height for Braille/Block)}

\item{\code{matrix}}{Character matrix for rendering}

\item{\code{color_matrix}}{Parallel matrix tracking colors per cell}

\item{\code{x_mult}}{Horizontal multiplier (pixels per character)}

\item{\code{y_mult}}{Vertical multiplier (pixels per character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Canvas-new}{\code{Canvas$new()}}
\item \href{#method-Canvas-set_pixel}{\code{Canvas$set_pixel()}}
\item \href{#method-Canvas-draw_line}{\code{Canvas$draw_line()}}
\item \href{#method-Canvas-draw_polyline}{\code{Canvas$draw_polyline()}}
\item \href{#method-Canvas-draw_points}{\code{Canvas$draw_points()}}
\item \href{#method-Canvas-fill_rect}{\code{Canvas$fill_rect()}}
\item \href{#method-Canvas-fill_bar}{\code{Canvas$fill_bar()}}
\item \href{#method-Canvas-draw_text}{\code{Canvas$draw_text()}}
\item \href{#method-Canvas-apply_colors}{\code{Canvas$apply_colors()}}
\item \href{#method-Canvas-render}{\code{Canvas$render()}}
\item \href{#method-Canvas-print}{\code{Canvas$print()}}
\item \href{#method-Canvas-clear}{\code{Canvas$clear()}}
\item \href{#method-Canvas-draw_rect}{\code{Canvas$draw_rect()}}
\item \href{#method-Canvas-fill_area}{\code{Canvas$fill_area()}}
\item \href{#method-Canvas-draw_segment}{\code{Canvas$draw_segment()}}
\item \href{#method-Canvas-draw_hline}{\code{Canvas$draw_hline()}}
\item \href{#method-Canvas-draw_vline}{\code{Canvas$draw_vline()}}
\item \href{#method-Canvas-draw_circle}{\code{Canvas$draw_circle()}}
\item \href{#method-Canvas-fill_circle}{\code{Canvas$fill_circle()}}
\item \href{#method-Canvas-draw_polygon}{\code{Canvas$draw_polygon()}}
\item \href{#method-Canvas-clone}{\code{Canvas$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-new"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-new}{}}}
\subsection{Method \code{new()}}{
Initialize the canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$new(width, height)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Character width}

\item{\code{height}}{Character height}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-set_pixel"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-set_pixel}{}}}
\subsection{Method \code{set_pixel()}}{
Set a pixel at the given coordinates
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$set_pixel(x, y, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate (1-based, in pixel space)}

\item{\code{y}}{Y coordinate (1-based, in pixel space, 1 = top)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_line"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_line}{}}}
\subsection{Method \code{draw_line()}}{
Draw a line between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_line(x0, y0, x1, y1, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x0}}{Start X coordinate}

\item{\code{y0}}{Start Y coordinate}

\item{\code{x1}}{End X coordinate}

\item{\code{y1}}{End Y coordinate}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_polyline"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_polyline}{}}}
\subsection{Method \code{draw_polyline()}}{
Draw multiple connected line segments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_polyline(xs, ys, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{Vector of X coordinates}

\item{\code{ys}}{Vector of Y coordinates}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_points"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_points}{}}}
\subsection{Method \code{draw_points()}}{
Draw points (scatter)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_points(xs, ys, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{Vector of X coordinates}

\item{\code{ys}}{Vector of Y coordinates}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-fill_rect"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-fill_rect}{}}}
\subsection{Method \code{fill_rect()}}{
Fill a rectangle
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$fill_rect(x0, y0, x1, y1, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x0}}{Left X coordinate}

\item{\code{y0}}{Top Y coordinate}

\item{\code{x1}}{Right X coordinate}

\item{\code{y1}}{Bottom Y coordinate}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-fill_bar"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-fill_bar}{}}}
\subsection{Method \code{fill_bar()}}{
Fill a vertical bar from bottom up to a height
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$fill_bar(x, height, bar_width = 2, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate (center of bar in pixel space)}

\item{\code{height}}{Height in pixels from bottom}

\item{\code{bar_width}}{Width of bar in pixels (default 2)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_text"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_text}{}}}
\subsection{Method \code{draw_text()}}{
Place text at a position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_text(x, y, text, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate (character position)}

\item{\code{y}}{Y coordinate (character position)}

\item{\code{text}}{Text string to place}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-apply_colors"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-apply_colors}{}}}
\subsection{Method \code{apply_colors()}}{
Apply colors to the matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$apply_colors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Matrix with ANSI color codes applied
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-render"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-render}{}}}
\subsection{Method \code{render()}}{
Get the rendered matrix (with colors)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$render()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-print"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-print}{}}}
\subsection{Method \code{print()}}{
Print the canvas to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-clear}{}}}
\subsection{Method \code{clear()}}{
Clear the canvas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_rect"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_rect}{}}}
\subsection{Method \code{draw_rect()}}{
Draw a rectangle outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_rect(x0, y0, x1, y1, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x0}}{Left X coordinate (pixel space)}

\item{\code{y0}}{Top Y coordinate (pixel space)}

\item{\code{x1}}{Right X coordinate (pixel space)}

\item{\code{y1}}{Bottom Y coordinate (pixel space)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-fill_area"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-fill_area}{}}}
\subsection{Method \code{fill_area()}}{
Fill an area between a polyline and the bottom
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$fill_area(xs, ys, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{Vector of X coordinates}

\item{\code{ys}}{Vector of Y coordinates}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_segment"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_segment}{}}}
\subsection{Method \code{draw_segment()}}{
Draw a segment (line with optional arrowhead)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_segment(x0, y0, x1, y1, arrow_end = FALSE, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x0}}{Start X coordinate}

\item{\code{y0}}{Start Y coordinate}

\item{\code{x1}}{End X coordinate}

\item{\code{y1}}{End Y coordinate}

\item{\code{arrow_end}}{Add arrowhead at end (default FALSE)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_hline"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_hline}{}}}
\subsection{Method \code{draw_hline()}}{
Draw a horizontal line
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_hline(y, x0 = 1, x1 = NULL, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{Y coordinate}

\item{\code{x0}}{Start X (default 1)}

\item{\code{x1}}{End X (default pixel_width)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_vline"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_vline}{}}}
\subsection{Method \code{draw_vline()}}{
Draw a vertical line
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_vline(x, y0 = 1, y1 = NULL, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{X coordinate}

\item{\code{y0}}{Start Y (default 1)}

\item{\code{y1}}{End Y (default pixel_height)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_circle"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_circle}{}}}
\subsection{Method \code{draw_circle()}}{
Draw a circle outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_circle(cx, cy, r, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cx}}{Center X coordinate}

\item{\code{cy}}{Center Y coordinate}

\item{\code{r}}{Radius in pixels}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-fill_circle"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-fill_circle}{}}}
\subsection{Method \code{fill_circle()}}{
Fill a circle
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$fill_circle(cx, cy, r, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cx}}{Center X coordinate}

\item{\code{cy}}{Center Y coordinate}

\item{\code{r}}{Radius in pixels}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-draw_polygon"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-draw_polygon}{}}}
\subsection{Method \code{draw_polygon()}}{
Draw a polygon outline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$draw_polygon(xs, ys, closed = TRUE, color = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{Vector of X coordinates}

\item{\code{ys}}{Vector of Y coordinates}

\item{\code{closed}}{Whether to close the polygon (default TRUE)}

\item{\code{color}}{Optional color name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Canvas-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Canvas-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Canvas$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
