% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.2samp.R
\name{corr.2samp}
\alias{corr.2samp}
\title{Power calculation for comparing two correlation coefficients}
\usage{
corr.2samp(
  n1 = NULL,
  n.ratio = 1,
  rho1 = NULL,
  rho2 = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{rho1}{The correlation coefficient in group 1.}

\item{rho2}{The correlation coefficient in group 2.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Calculates power and sample size for a test that the correlation coefficients in two groups/populations
are equal. Can solve for power, n1, n.ratio or alpha.
}
\examples{
corr.2samp(n1 = 300, rho1 = 0.3, rho2 = 0.1, sides = 1)
}
