% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_labels.R
\name{read_labels}
\alias{read_labels}
\title{Read and apply a reordered attribute/level mapping}
\usage{
read_labels(.data, .filename)
}
\arguments{
\item{.data}{A \code{\link{projoint_data}} object whose labels/data should be reordered.}

\item{.filename}{Path to the revised labels CSV (originally produced from the package's labels).}
}
\value{
A \code{\link{projoint_data}} object with the same content as \code{.data} but with
  attributes and levels reordered to match the CSV. The returned object contains:
  \itemize{
    \item \code{$labels}: a tibble with new \code{attribute_id} and \code{level_id} reflecting the chosen order
    \item \code{$data}: a tibble whose \code{att*} columns have been remapped to the new \code{level_id}s
  }
}
\description{
Reads a CSV containing a revised ordering of attributes and levels and applies it
to an existing \code{\link{projoint_data}} object. Typical workflow: first save the
current labels to CSV (e.g., with \code{\link{save_labels}}), manually reorder rows
(and/or the attribute grouping) in the CSV, then call \code{read_labels()} to apply.
}
\examples{
\donttest{
# Create a projoint_data object from the example dataset
data(exampleData1)
outcomes <- c(paste0("choice", 1:8), "choice1_repeated_flipped")
pj <- reshape_projoint(exampleData1, outcomes)

# Write current labels to a temporary CSV, adding an 'order' column
tmp <- tempfile(fileext = ".csv")
pj$labels |>
  dplyr::mutate(order = dplyr::row_number()) |>
  readr::write_csv(tmp)

# (User would reorder rows in 'tmp' manually; we just read it back)
pj_reordered <- read_labels(pj, tmp)

# Inspect the updated label order
head(pj_reordered$labels)
}

}
\seealso{
\code{\link{save_labels}}, \code{\link{reshape_projoint}}
}
