% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepInputs.R
\name{extractFromArchive}
\alias{extractFromArchive}
\title{Extract files from archive}
\usage{
extractFromArchive(
  archive,
  destinationPath = getOption("reproducible.destinationPath", dirname(archive)),
  neededFiles = NULL,
  extractedArchives = NULL,
  checkSums = NULL,
  needChecksums = 0,
  filesExtracted = character(),
  checkSumFilePath = character(),
  quick = FALSE,
  verbose = getOption("reproducible.verbose", 1),
  .tempPath,
  ...
)
}
\arguments{
\item{archive}{Character string giving the path of the archive
containing the \code{file} to be extracted. This path must exist or be \code{NULL}}

\item{destinationPath}{Character string giving the path where \code{neededFiles} will be
extracted. Defaults to the archive directory.}

\item{neededFiles}{Character string giving the name of the file(s) to be extracted.}

\item{extractedArchives}{Used internally to track archives that have been extracted from.}

\item{checkSums}{A checksums file, e.g., created by Checksums(..., write = TRUE)}

\item{needChecksums}{A numeric, with \code{0} indicating do not write a new checksums,
\code{1} write a new one,
\code{2} append new information to existing one.}

\item{filesExtracted}{Used internally to track files that have been extracted.}

\item{checkSumFilePath}{The full path to the checksum.txt file}

\item{quick}{Passed to \code{Checksums}}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{.tempPath}{Optional temporary path for internal file intermediate steps.
Will be cleared \code{on.exit} from this function.}

\item{...}{Passed to \code{unzip} or \code{untar}, e.g., \code{overwrite}}
}
\value{
A character vector listing the paths of the extracted archives.
}
\description{
Extract zip or tar archive files, possibly nested in other zip or tar archives.
}
\author{
Jean Marchal and Eliot McIntire
}
