% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcessTo.R
\name{gdalProject}
\alias{gdalProject}
\alias{gdalResample}
\alias{gdalMask}
\title{3-Step postProcess sequence for SpatRasters using \code{gdalwarp}}
\usage{
gdalProject(
  fromRas,
  toRas,
  filenameDest,
  verbose = getOption("reproducible.verbose"),
  ...
)

gdalResample(
  fromRas,
  toRas,
  filenameDest,
  verbose = getOption("reproducible.verbose"),
  ...
)

gdalMask(
  fromRas,
  maskToVect,
  writeTo = NULL,
  verbose = getOption("reproducible.verbose"),
  ...
)
}
\arguments{
\item{fromRas}{see \code{from} argument from \code{\link[=postProcessTo]{postProcessTo()}}, but can only be a  \code{SpatRaster}.}

\item{toRas}{see \code{to} argument from \code{\link[=postProcessTo]{postProcessTo()}}, but can only be a  \code{SpatRaster}.}

\item{filenameDest}{A filename with an appropriate extension (e.g., \code{.tif}) for
\code{gdal} to write the output to. Since this function is conceived to be part of a
chain, and not the final step, this function does not use \code{writeTo}, which is
reserved for the final step in the chain.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{For \code{gdalProject}, this can be \code{method}. For \code{gdalMask} can be \code{destinationPath} and \code{touches}.
For all \verb{gdal*}, this can also be and \code{datatype}.}

\item{maskToVect}{see \code{maskTo} argument from \code{\link[=maskTo]{maskTo()}}, but can only be a \code{SpatVector}}

\item{writeTo}{Optional character string of a filename to use \code{writeRaster} to save the final
object. Default is \code{NULL}, which means there is no \code{writeRaster}}
}
\description{
DEFUNCT: Please use the \code{postProcessTo} functions.

\code{gdalResample} is a thin wrapper around \code{sf::gdal_utils('gdalwarp', ...)} with specific options
set, notably, \verb{"-r", "near"}, \code{-te}, \code{-te_srs}, \code{tr}, \code{-dstnodata = NA}, \code{-overwrite}.

\code{gdalMask} is a thin wrapper around \code{sf::gdal_utils('gdalwarp', ...)} with specific options
set, notably, \code{-cutline}, \code{-dstnodata = NA}, and \code{-overwrite}.
}
\details{
\code{gdalProject} is a thin wrapper around \code{sf::gdal_utils('gdalwarp', ...)} with specific options
set, notably, \code{-r} to \code{method} (in the ...), \code{-t_srs} to the crs of the \code{toRas},
\code{-te} to the extent of the \code{toRas}, \code{-te_srs} to the \code{crs} of the \code{toRas},
\code{-dstnodata = NA}, and \code{-overwrite}.

These three functions are used within \code{postProcessTo}, in the sequence:
\code{gdalProject}, \code{gdalResample} and \code{gdalMask}, when \code{from} and \code{projectTo} are \code{SpatRaster} and
\code{maskTo} is a \code{SpatVector}, but only if \code{options(reproducible.gdalwarp = TRUE)} is set.

This sequence is a slightly different order than the sequence when \code{gdalwarp = FALSE} or
the arguments do not match the above. This sequence was determined to be faster and
more accurate than any other sequence, including running all three steps in one
\code{gdalwarp} call (which \code{gdalwarp} can do). Using one-step \code{gdalwarp} resulted in
very coarse pixelation when converting from a coarse resolution to fine resolution, which
visually was inappropriate in test cases.
}
\examples{
if (require("terra", quietly = TRUE)) {
  # prepare dummy data -- 3 SpatRasters, 2 SpatVectors
  # need 2 SpatRaster
  rf <- system.file("ex/elev.tif", package = "terra")
  elev1 <- terra::rast(rf)

  # a polygon vector
  f <- system.file("ex/lux.shp", package = "terra")
  vOrig <- terra::vect(f)
  v <- vOrig[1:2, ]

  # utm <- terra::crs("epsg:23028") # $wkt
  utm <- "+proj=utm +zone=28 +datum=WGS84 +units=m +no_defs"
  vInUTM <- terra::project(vOrig, utm)
  vAsRasInLongLat <- terra::rast(vOrig, resolution = 0.008333333)
  res100 <- 100
  rInUTM <- terra::rast(vInUTM, resolution = res100, vals = 1)
  # crop, reproject, mask, crop a raster with a vector in a different projection
  #  --> gives message about not enough information
  t1 <- postProcessTo(elev1, to = vInUTM)
  # crop, reproject, mask a raster to a different projection, then mask
  t2a <- postProcessTo(elev1, to = vAsRasInLongLat, maskTo = vInUTM)
  t3a <- postProcessTo(elev1, to = rInUTM, maskTo = vInUTM)

}
}
\seealso{
\code{\link[=gdalResample]{gdalResample()}}, and \code{\link[=gdalMask]{gdalMask()}} and the overarching \code{\link[=postProcessTo]{postProcessTo()}}
}
