% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_squash}
\alias{quo_squash}
\title{Squash a quosure}
\usage{
quo_squash(quo, warn = FALSE)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{warn}{Whether to warn if the quosure contains other quosures
(those will be collapsed). This is useful when you use
\code{quo_squash()} in order to make a non-tidyeval API compatible
with quosures. In that case, getting rid of the nested quosures
is likely to cause subtle bugs and it is good practice to warn
the user about it.}
}
\description{
\code{quo_squash()} flattens all nested quosures within an expression.
For example it transforms \verb{^foo(^bar(), ^baz)} to the bare
expression \code{foo(bar(), baz)}.

This operation is safe if the squashed quosure is used for
labelling or printing (see \code{\link[=as_label]{as_label()}}, but note that \code{as_label()}
squashes quosures automatically). However if the squashed quosure
is evaluated, all expressions of the flattened quosures are
resolved in a single environment. This is a source of bugs so it is
good practice to set \code{warn} to \code{TRUE} to let the user know about
the lossy squashing.
}
\examples{
# Quosures can contain nested quosures:
quo <- quo(wrapper(!!quo(wrappee)))
quo

# quo_squash() flattens all the quosures and returns a simple expression:
quo_squash(quo)
}
