% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classMethods_getValues.r
\name{getVars}
\alias{getVars}
\title{Query Values of State Variables}
\arguments{
\item{asArray}{Logical. If \code{FALSE}, the values of variables are returned
as vector irrespective of the model's spatial resolution. If \code{TRUE},
the values are returned as an \code{\link[base]{array}} with properly named
dimensions. The array's last dimension represents the variables and its
first (fastest cycling) dimension, if any, refers to the model's highest
spatial dimension.}

\item{useNames}{Logical. Used to enable/disable element names for the return
vector when \code{asArray} is \code{FALSE}. The names follow the pattern
'x.i.j' where 'x' is the variable name and 'i', 'j' are indices of the
sub-units in the first and second spatial dimension. The actual suffix is
controlled by the number of dimensions and in the 0-dimensional case, no
suffix is applied at all, i.e. the pure variable names are used to label the
elements of the vector.
If \code{isArray} is \code{TRUE}, this argument is simply ignored, hence
the dimensions of a returned array are always named.}
}
\value{
A numeric vector or array.
}
\description{
Query values of state variables of a \code{\link{rodeo}}-based model.
}
\seealso{
The corresponding 'set' method is \code{\link{setVars}} and examples
 can be found there. Use \code{\link{getPars}} to query the values of
 parameters rather than variables.
}
\author{
\email{david.kneis@tu-dresden.de}
}
