% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat.R
\name{Stacked_VlnPlot}
\alias{Stacked_VlnPlot}
\title{Stacked Violin Plot}
\usage{
Stacked_VlnPlot(
  seurat_object,
  features,
  group.by = NULL,
  split.by = NULL,
  idents = NULL,
  x_lab_rotate = FALSE,
  plot_legend = FALSE,
  colors_use = NULL,
  color_seed = 123,
  ggplot_default_colors = FALSE,
  plot_spacing = 0.15,
  spacing_unit = "cm",
  vln_linewidth = NULL,
  pt.size = NULL,
  raster = NULL,
  add.noise = TRUE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Features to plot.}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident).}

\item{split.by}{A variable to split the violin plots by,}

\item{idents}{Which classes to include in the plot (default is all).}

\item{x_lab_rotate}{logical or numeric.  If logical whether to rotate x-axis labels 45 degrees
(Default is FALSE).  If numeric must be either 45 or 90.  Setting 45 is equivalent to setting TRUE.}

\item{plot_legend}{logical.  Adds plot legend containing \code{idents} to the returned plot.}

\item{colors_use}{specify color palette to used in \code{\link[Seurat]{VlnPlot}}.  By default if
number of levels plotted is less than or equal to 36 it will use "polychrome" and if greater than 36
will use "varibow" with shuffle = TRUE both from \code{DiscretePalette_scCustomize}.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{plot_spacing}{Numerical value specifying the vertical spacing between each plot in the stack.
Default is 0.15 ("cm").  Spacing dependent on unit provided to \code{spacing_unit}.}

\item{spacing_unit}{Unit to use in specifying vertical spacing between plots.  Default is "cm".}

\item{vln_linewidth}{Adjust the linewidth of violin outline.  Must be numeric.}

\item{pt.size}{Adjust point size for plotting.  Default for \code{Stacked_VlnPlot} is 0 to avoid issues with
rendering so many points in vector form.  Alternatively, see \code{raster} parameter.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 total points plotted (# Cells x # of features).}

\item{add.noise}{logical, determine if adding a small noise for plotting (Default is TRUE).}

\item{...}{Extra parameters passed to \code{\link[Seurat]{VlnPlot}}.}
}
\value{
A ggplot object
}
\description{
Code for creating stacked violin plot gene expression.
}
\examples{
library(Seurat)
Stacked_VlnPlot(seurat_object = pbmc_small, features = c("CD3E", "CD8", "GZMB", "MS4A1"),
x_lab_rotate = TRUE)

}
\references{
\url{https://divingintogeneticsandgenomics.rbind.io/post/stacked-violin-plot-for-visualizing-single-cell-data-in-seurat/}
}
\seealso{
\url{https://x.com/tangming2005}
}
\author{
Ming Tang (Original Code), Sam Marsh (Wrap single function, added/modified functionality)
}
\concept{seurat_plotting}
