% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scoper.R
\name{scoper}
\alias{scoper}
\title{The SCOPer package}
\description{
\code{scoper} is a member of the Immcantation framework and provides computational approaches 
for the identification of B cell clones from adaptive immune receptor repertoire sequencing 
(AIRR-Seq) datasets. It includes methods for assigning clonal identifiers using
sequence identity, hierarchical clustering, and spectral clustering.
}
\section{Clonal clustering}{


\itemize{
  \item  \link{identicalClones}:  Clonal assignment using sequence identity partitioning.
  \item  \link{hierarchicalClones}:  Hierarchical clustering approach to clonal assignment.
  \item  \link{spectralClones}:  Spectral clustering approach to clonal assignment.
}
}

\section{Visualization}{

\itemize{
  \item  \link{plotCloneSummary}:  Visualize inter- and intra-clone distances.
}
}

\references{
\enumerate{
  \item  Nouri N and Kleinstein SH (2018). A spectral clustering-based method for identifying clones
  from high-throughput B cell repertoire sequencing data. Bioinformatics, 34(13):i341-i349.
  \item  Nouri N and Kleinstein SH (2019). Somatic hypermutation analysis for improved identification 
  of B cell clonal families from next-generation sequencing data. bioRxiv, 10.1101/788620.
  \item Gupta NT, et al. (2017). Hierarchical clustering can identify B cell clones with high 
  confidence in Ig repertoire sequencing data. The Journal of Immunology, 198(6):2489-2499.
}
}
