% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_center_distance_matrix.R
\name{double_center_distance_matrix}
\alias{double_center_distance_matrix}
\title{Double-center a distance matrix}
\usage{
double_center_distance_matrix(distance.matrix = NULL, distance.threshold = 0)
}
\arguments{
\item{distance.matrix}{Numeric distance matrix. Default: \code{NULL}.}

\item{distance.threshold}{Numeric distance threshold for weight calculation. Distances above this threshold are set to 0 during weighting. Default: \code{0}.}
}
\value{
Double-centered numeric matrix with the same dimensions as \code{distance.matrix}. The matrix has row means and column means of zero.
}
\description{
Double-centers a distance matrix by converting it to weights and centering to zero row and column means. Required for computing Moran's Eigenvector Maps.
}
\details{
Double-centering is performed in two steps:
\enumerate{
\item Convert distances to weights using \code{\link[=weights_from_distance_matrix]{weights_from_distance_matrix()}}
\item Center the matrix: subtract row means, subtract column means, and add the grand mean
}
The resulting matrix is symmetric with zero row and column means, suitable for Moran's Eigenvector Maps computation.
}
\examples{
data(plants_distance)

# Double-center the distance matrix
centered <- double_center_distance_matrix(
  distance.matrix = plants_distance
)

# Verify row means are zero
head(rowMeans(centered))

# Verify column means are zero
head(colMeans(centered))

}
\seealso{
\code{\link[=weights_from_distance_matrix]{weights_from_distance_matrix()}}, \code{\link[=mem]{mem()}}, \code{\link[=mem_multithreshold]{mem_multithreshold()}}

Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{auto_vif}()},
\code{\link{case_weights}()},
\code{\link{default_distance_thresholds}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
