% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollmean_date.R
\name{rollmean_date}
\alias{rollmean_date}
\title{Rolling mean of values indexed by date}
\usage{
rollmean_date(
  dates,
  values,
  look_behind = 2,
  look_ahead = 0,
  look_units = "days"
)
}
\arguments{
\item{dates}{A vector of dates of 'Date' class.}

\item{values}{Numeric values. The values must be in correspondence with \code{dates}, meaning the
\emph{i}th element in \code{values} must correspond to the \emph{i}th date in \code{dates}.}

\item{look_behind, look_ahead}{The number of \code{look_units} before and after the center date to
include in the sliding window.}

\item{look_units}{One of "days", "weeks", or "months". The units to give \code{look_ahead} and
\code{look_behind}.}
}
\value{
A numeric vector with length equal to \code{dates} and \code{values}.
}
\description{
Calculate the rolling mean of a set of numbers indexed by date.
}
\details{
The amount of time to include in the rolling mean is defined by \code{look_behind} and \code{look_ahead}.
All values within the look-behind, the index, and the look-ahead will be used to calculate the
average. If \code{look_behind} is 5 days and \code{look_ahead} is 0 days, then all values within the 5 days
before the current index (i.e., the 6th day) will be included - it is a 6-day moving average.
If \code{look_behind} is 5 days and \code{look_ahead} is 5 days, then it is a 11-day moving average centered
on the 6th day.

The mean is calculated without \code{NA} values. If one value in the window is \code{NA}, then the rolling
mean is that of all values within the window which are not \code{NA}.
}
\examples{
date_vec <- seq.Date(
  from = as.Date("2020-01-01"), 
  to = as.Date("2020-01-05"), 
  by = "day"
)
num_vec <- c(2, 3, 4, 20, 10)
results <- rollmean_date(
  dates = date_vec, 
  values = num_vec, 
  look_behind = 2
 )
data.frame(
  "date" = date_vec, 
  "values" = num_vec, 
  "roll_mean" = results
)

# Missing data and 10-day moving window
date_vec <- seq.Date(
  from = as.Date("2020-01-01"), 
  to = as.Date("2020-03-31"), 
  by = "day"
)
set.seed(123)
num_vec <- sample(1:30, length(date_vec), replace = TRUE)
set.seed(123)
r <- sample(1:length(date_vec), 20)
results <- rollmean_date(
  dates = date_vec[-r], 
  values = num_vec[-r], 
  look_behind = 5, 
  look_ahead = 4
 )
head(
  data.frame(
    "date" = date_vec[-r], 
    "values" = num_vec[-r], 
    "roll_mean" = results
  ), 
  10
)

}
