% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db_init}
\alias{db_init}
\title{Initialize PostgreSQL Database for taskqueue}
\usage{
db_init()
}
\value{
Invisibly returns NULL. Called for side effects (creating database schema).
}
\description{
Creates the necessary database schema for taskqueue, including all required
tables, types, and constraints. This function must be run once before using
taskqueue for the first time.
}
\details{
This function creates:
\itemize{
  \item Custom PostgreSQL types (e.g., \code{task_status} enum)
  \item \code{project} table for managing projects
  \item \code{resource} table for computing resources
  \item \code{project_resource} table for project-resource associations
}

It is safe to call this function multiple times; existing tables and types
will not be modified or deleted.
}
\examples{
\dontrun{
# Not run:
# Initialize database (run once)
db_init()

# Verify initialization
con <- db_connect()
DBI::dbListTables(con)
db_disconnect(con)
}
}
\seealso{
\code{\link{db_clean}}, \code{\link{db_connect}}
}
