% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{palette_colors}
\alias{palette_colors}
\title{Color palettes collected}
\usage{
palette_colors(
  x,
  n = 100,
  palette = "Paired",
  palcolor = NULL,
  type = c("auto", "discrete", "continuous"),
  matched = FALSE,
  reverse = FALSE,
  NA_keep = FALSE,
  NA_color = "grey80"
)
}
\arguments{
\item{x}{A vector of character/factor or numeric values.
If missing, numeric values 1:n will be used as x.}

\item{n}{The number of colors to return for numeric values.}

\item{palette}{Palette name.
All available palette names can be queried with \link{show_palettes}.}

\item{palcolor}{Custom colors used to create a color palette.}

\item{type}{Type of \code{x}.
Can be one of \code{"auto"}, \code{"discrete"} or \code{"continuous"}.
The default is \code{"auto"}, which automatically detects if \code{x} is a numeric value.}

\item{matched}{Whether to return a color vector of the same length as \code{x}.
Default is \code{FALSE}.}

\item{reverse}{Whether to invert the colors.
Default is \code{FALSE}.}

\item{NA_keep}{Whether to keep the color assignment to NA in \code{x}.
Default is \code{FALSE}.}

\item{NA_color}{Color assigned to NA if \code{NA_keep} is \code{TRUE}.
Default is \code{"grey80"}.}
}
\value{
A character vector of color codes (hexadecimal format) corresponding to the input values \code{x}. The length and structure depend on the \code{matched} parameter.
}
\description{
This function creates a color palette for a given vector of values.
}
\examples{
x <- c(1:3, NA, 3:5)
(pal1 <- palette_colors(
  x,
  palette = "Spectral"
))
(pal2 <- palette_colors(
  x,
  palcolor = c("red", "white", "blue")
))
(pal3 <- palette_colors(
  x,
  palette = "Spectral",
  n = 10
))
(pal4 <- palette_colors(
  x,
  palette = "Spectral",
  n = 10,
  reverse = TRUE
))
(pal5 <- palette_colors(
  x,
  palette = "Spectral",
  matched = TRUE
))
(pal6 <- palette_colors(
  x,
  palette = "Spectral",
  matched = TRUE,
  NA_keep = TRUE
))
show_palettes(
  list(pal1, pal2, pal3, pal4, pal5, pal6)
)

# Use Chinese color palettes
palette_colors(
  x = letters[1:5],
  palette = "ChineseRed",
  type = "discrete"
)
palette_colors(
  x = letters[1:5],
  palette = "Chinese",
  type = "discrete"
)

all_palettes <- show_palettes(return_palettes = TRUE)
names(all_palettes)
}
\seealso{
\link{show_palettes}, \link{palette_list}
}
