% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_impute_xgboost.R
\name{gt_impute_xgboost}
\alias{gt_impute_xgboost}
\title{Imputation based XGBoost}
\usage{
gt_impute_xgboost(
  x,
  alpha = 1e-04,
  size = 200,
  p_train = 0.8,
  n_cor = nrow(x),
  seed = NA,
  n_cores = 1,
  append_error = TRUE
)
}
\arguments{
\item{x}{a \link{gen_tibble} with missing data}

\item{alpha}{Type-I error for testing correlations. Default is \code{1e-4}.}

\item{size}{Number of neighbour SNPs to be possibly included in the model
imputing this particular SNP. Default is \code{200}.}

\item{p_train}{Proportion of non missing genotypes that are used for training
the imputation model while the rest is used to assess the accuracy of
this imputation model. Default is \code{0.8}.}

\item{n_cor}{Number of rows that are used to estimate correlations.
Default uses them all.}

\item{seed}{An integer, for reproducibility. Default doesn't use seeds.}

\item{n_cores}{the number of cores to be used}

\item{append_error}{boolean, should the xgboost error estimates be appended
as an attribute to the genotype column of
the gen_tibble. If TRUE (the default), a matrix of two rows (the number
of missing values, and the error estimate) and as many columns as the number
of loci will be appended to the gen_tibble.
attr(missing_gt$genotypes, "imputed_errors")}
}
\value{
a \link{gen_tibble} with imputed genotypes
}
\description{
This function provides a simple imputation algorithm for \code{gen_tibble}
objects based on local XGBoost models.
}
\details{
This function is a wrapper around \code{\link[bigsnpr:snp_fastImpute]{bigsnpr::snp_fastImpute()}}. The error
rates from the xgboost, if appended, can be retrieved with
\code{attr(x$genotypes, "imputed_errors")} where \code{x} is the \code{gen_tibble}.
}
\examples{
\dontshow{if (rlang::is_installed(c("xgboost", "RhpcBLASctl", "data.table"))) withAutoprint(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("gen_tbl")

# Impute the gen_tibble
example_gt <- example_gt \%>\% gt_impute_xgboost()

# And we can check it has been imputed
example_gt \%>\% gt_has_imputed()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[bigsnpr:snp_fastImpute]{bigsnpr::snp_fastImpute()}} which this function wraps.
}
