% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na}
\alias{replace_na}
\title{Replace NAs with specified values}
\usage{
replace_na(data, replace, ...)
}
\arguments{
\item{data}{A data frame or vector.}

\item{replace}{If \code{data} is a data frame, \code{replace} takes a named list of
values, with one value for each column that has missing values to be
replaced. Each value in \code{replace} will be cast to the type of the column
in \code{data} that it being used as a replacement in.

If \code{data} is a vector, \code{replace} takes a single value. This single value
replaces all of the missing values in the vector. \code{replace} will be cast
to the type of \code{data}.}

\item{...}{Additional arguments for methods. Currently unused.}
}
\value{
\code{replace_na()} returns an object with the same type as \code{data}.
}
\description{
Replace NAs with specified values
}
\examples{
# Replace NAs in a data frame
df <- tibble(x = c(1, 2, NA), y = c("a", NA, "b"))
df |> replace_na(list(x = 0, y = "unknown"))

# Replace NAs in a vector
df |> dplyr::mutate(x = replace_na(x, 0))
# OR
df$x |> replace_na(0)
df$y |> replace_na("unknown")

# Replace NULLs in a list: NULLs are the list-col equivalent of NAs
df_list <- tibble(z = list(1:5, NULL, 10:20))
df_list |> replace_na(list(z = list(5)))
}
\seealso{
\code{\link[dplyr:na_if]{dplyr::na_if()}} to replace specified values with \code{NA}s;
\code{\link[dplyr:coalesce]{dplyr::coalesce()}} to replaces \code{NA}s with values from other vectors.
}
