% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLinearProjection.R
\name{logLinearProjection}
\alias{logLinearProjection}
\title{Log-Linear Projection (data-masked, dplyr-native)}
\usage{
logLinearProjection(
  date,
  value,
  start_date,
  end_date,
  group = NULL,
  data = NULL
)
}
\arguments{
\item{date}{Bare column name for the date variable (coercible to Date).}

\item{value}{Bare column name for the positive numeric series to project.}

\item{start_date}{Date or string coercible to Date; start of calibration.}

\item{end_date}{Date or string coercible to Date; end of calibration.}

\item{group}{Optional bare column name to group by before projecting.}

\item{data}{Optional data frame. If omitted, uses the current data mask
(e.g., inside \code{mutate()}) via \code{dplyr::cur_data_all()}.}
}
\value{
A numeric vector \code{projection} aligned to the input rows; \code{NA}
before \code{start_date}. Respects grouping if \code{group} is supplied.
}
\description{
Fits a log-linear trend \code{log(value) ~ t} on a calibration window and
projects it for rows on/after \code{start_date}. Designed for use inside
dplyr verbs (no need to pass \code{.}).
}
