% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transGFM.R
\name{ic_criterion}
\alias{ic_criterion}
\title{Information criterion (IC1/IC2) for selecting number of factors}
\usage{
ic_criterion(
  X,
  r_max = 10,
  ic_type = c("IC1", "IC2"),
  data_type = "count",
  C = NULL,
  max_iter = 30,
  verbose = FALSE
)
}
\arguments{
\item{X}{Data matrix (may contain missing values coded as NA)}

\item{r_max}{Maximum number of factors to consider (default: 10)}

\item{ic_type}{IC criterion type: "IC1" or "IC2" (default: "IC1")}

\item{data_type}{Type of data: "continuous", "count", or "binary"}

\item{C}{CJMLE projection constant (if NULL, auto-calculated)}

\item{max_iter}{Maximum CJMLE iterations (default: 30)}

\item{verbose}{Print progress information (default: FALSE)}
}
\value{
List with r_hat (optimal rank), ic_values, loglik_values
}
\description{
Information criterion (IC1/IC2) for selecting number of factors
}
\examples{
# Generate Poisson data with known rank
set.seed(2025)
n <- 100; p <- 100; r_true <- 2

# Generate true factors
F_true <- matrix(runif(n * r_true, min = -2, max = 2), n, r_true)
B_true <- matrix(runif(p * r_true, min = -2, max = 2), p, r_true)
M_true <- F_true \%*\% t(B_true)

# Generate Poisson observations
lambda <- exp(M_true)
X <- matrix(rpois(n * p, as.vector(lambda)), n, p)

# Add 10\% missing values
n_missing <- floor(n * p * 0.1)
missing_idx <- sample(n * p, n_missing)
X[missing_idx] <- NA

# Use IC1 to select rank
result_IC1 <- ic_criterion(
  X = X,
  r_max = 6,
  ic_type = "IC1",
  data_type = "count",
  verbose = TRUE
)

print(paste("True rank:", r_true))
print(paste("Estimated rank (IC1):", result_IC1$r_hat))

# Use IC2 to select rank
result_IC2 <- ic_criterion(
  X = X,
  r_max = 6,
  ic_type = "IC2",
  data_type = "count",
  verbose = TRUE
)

}
