% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{prepare_log_matrices}
\alias{prepare_log_matrices}
\title{Prepare Log-Transformed Matrices}
\usage{
prepare_log_matrices(
  direct_prices,
  production_prices,
  exclude_cols = c("Year")
)
}
\arguments{
\item{direct_prices}{Data frame with direct prices.}

\item{production_prices}{Data frame with prices of production.}

\item{exclude_cols}{Character vector of columns to exclude.
Default c("Year").}
}
\value{
A list containing:
\describe{
  \item{X_log}{Log-transformed matrix of direct prices}
  \item{Y_log}{Log-transformed matrix of production prices}
  \item{complete_cases}{Logical vector indicating complete cases}
  \item{X_clean}{Subset of X_log with complete cases}
  \item{Y_clean}{Subset of Y_log with complete cases}
}
}
\description{
Extracts numeric columns from price data frames and applies log transform.
}
\examples{
set.seed(123)
direct <- data.frame(
  Year = 2000:2005,
  A = runif(6, 100, 200),
  B = runif(6, 100, 200)
)
production <- data.frame(
  Year = 2000:2005,
  A = runif(6, 100, 200),
  B = runif(6, 100, 200)
)
matrices <- prepare_log_matrices(direct, production)
str(matrices)

}
