% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wav.R
\name{read_wav}
\alias{read_wav}
\alias{write_wav}
\title{Read/write wav files}
\usage{
read_wav(path)

write_wav(x, path, sample_rate = 44100, bit_depth = 32, ..., normalize = TRUE)
}
\arguments{
\item{path}{Path to file that will be read or written to.}

\item{x}{Numeric matrix with dimensions \verb{[n_channels, n_samples]}. Values in
the matrix should be \verb{<double>} in the range \verb{[-1, 1]} or integers in the range
\verb{[-.Machine$integer.max, .Machine$integer.max]} ie. 32 bits signed integers
like R integers containing the amplitudes. Depending on the value of \code{normalize}
and the \code{bit_depth} you can use different ranges.}

\item{sample_rate}{Sample rate in Hz of the associated samples.}

\item{bit_depth}{Bit depth of associated samples. This only affects the precision
data is saved to the file.}

\item{...}{Currently unused.}

\item{normalize}{Boolean idicating wheter integers should be normalized before
writing. Only used when \code{\link[=write_wav]{write_wav()}} is called with a integer matrix.
For example when you write a sample with a amplitude value of \code{2147483647}
and \code{bit_depth = 8}, you would need to normalize this integer so it
actually refers to the maximum unsigned int available (i.e. \code{255}).
You can avoid normalizing when the amplitudes are already in the correct integer
range for the \code{bit_depth} you are saving, in this case provide \code{normalize = FALSE}.}
}
\value{
\itemize{
\item When reading: A numeric matrix with samples. It also contains the attributes \code{sample_rate}
and \code{bit_depth}.
\item When writing: A boolean which is \code{TRUE} if writing was sucessful and \code{FALSE}
otherwise.
}
}
\description{
Efficiently read and write \href{https://en.wikipedia.org/wiki/WAV}{WAV files}.
}
\section{Functions}{
\itemize{
\item \code{write_wav()}: Write a wav file.

}}
\examples{
x <- matrix(sin(440 * seq(0, 2*pi, length = 44100)), nrow=1)
tmp <- tempfile(fileext = ".wav")
write_wav(x, tmp)
y <- read_wav(tmp)
all.equal(as.numeric(x), as.numeric(y), tolerance = 1e-7)

}
