% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadruplot.R
\name{quadruplot}
\alias{quadruplot}
\title{Four EDA Plots for Visual Assessment of Location-Shift Assumption}
\usage{
quadruplot(
  formula,
  data,
  ref_level = NULL,
  test = "ks",
  seed = 123L,
  ylab = NULL,
  color_palette = "lancet",
  combine_plots = TRUE,
  distribution = "norm",
  show_colors = TRUE,
  show_legend = TRUE
)
}
\arguments{
\item{formula}{Formula of the form \code{response ~ group}}

\item{data}{Data frame containg response, group}

\item{ref_level}{Character, reference level of the grouping factor. If NULL (default),
uses first factor level}

\item{test}{Character, statistical test for shift-equivalence assumption.
Tests for distributional equality applied to median-centered data:
"ks" (Kolmogorov-Smirnov) (default), "kuiper" (Kuiper), "cvm" (Cramér-von Mises),
"ad" (Anderson-Darling), "wass" (Wasserstein), "dts" (DTS test).}

\item{seed}{Numeric, for set.seed() used in \code{test_shift_equivalence()} for bootstrap.}

\item{ylab}{Character, label for y-axis. If NULL (default), uses variable name}

\item{color_palette}{Character, color palette to use. One of "viridis", "plasma",
"inferno", "magma", or "cividis"}

\item{combine_plots}{Logical, whether to return combined plot using patchwork
(TRUE) or list of individual plots (FALSE)}

\item{distribution}{Character, theoretical distribution for Q-Q plot comparison.
Default is "norm" for normal distribution}

\item{show_colors}{Logical, whether to use colors (TRUE) or grayscale (FALSE)}

\item{show_legend}{Logical, whether to display legend in plots (default TRUE)}
}
\value{
If combine_plots = TRUE, returns a combined ggplot object created by
patchwork. If FALSE, returns a list of four ggplot objects named 'boxplot',
'density', 'wormplot', and 'ecdf'.
}
\description{
Creates four diagnostic plots to visually assess whether the location-shift
assumption \eqn{F_1(x) = F_2(x - \delta)}{F1(x) = F2(x - delta)} holds:
(1) boxplot with swarmplot overlay,
(2) density plot comparison, (3) wormplot of median-centered residuals, and
(4) empirical CDF comparison with confidence band for median-centered data.
}
\details{
The location-shift assumption is assessed by applying a test of H0: equality
of distributions to median-centered data. One of the tests from the \code{twosamples}
package can be used. The empirical CDF plot includes 95\% confidence bands for
the difference between distributions, computed using the \code{sfsmisc::KSd} function
based on the Kolmogorov-Smirnov distribution. These bands help assess whether
observed differences between median-centered distributions exceed what would be
expected under the location-shift assumption.
}
\note{
Uses \pkg{twosamples} for distribution comparison and
\code{KSd} from \pkg{sfsmisc} for exact confidence bands.
}
\examples{
library(wmwAUC)

data(Ex2)
da <- Ex2
qp = quadruplot(y ~ group, data = da, ref_level = 'control')
qp


}
\references{
O'Dowd, C. (2025). Statistical Code Examples.
\url{https://codowd.com/code} (accessed November 28, 2025).

Maechler M (2024). \emph{sfsmisc: Utilities from 'Seminar fuer Statistik' ETH
Zurich}. R package version 1.1-20,
\url{https://CRAN.R-project.org/package=sfsmisc}.
}
