% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{base64_uri}
\alias{base64_uri}
\title{Generate the Data URI for a file}
\usage{
base64_uri(x, type = mime_type(x))
}
\arguments{
\item{x}{A file path.}

\item{type}{The MIME type of the file, e.g., \code{"image/png"} for a PNG image
file.}
}
\value{
A string of the form \verb{data:<media type>;base64,<data>}.
}
\description{
Encode the file in the base64 encoding, and add the media type. The data URI
can be used to embed data in HTML documents, e.g., in the \code{src} attribute of
the \verb{<img />} tag.
}
\examples{
logo = xfun:::R_logo()
img = xfun::html_tag("img", src = xfun::base64_uri(logo), alt = "R logo")
if (interactive()) xfun::html_view(img)
}
